<?php
/* --------------------------------------------------------------
   Languages.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Model;

use ArrayIterator;
use Gambio\Core\Language\Language;

/**
 * Class Languages
 *
 * @package Gambio\Core\Language\Model
 */
class Languages implements \Gambio\Core\Language\Languages
{
    /**
     * @var Language[]
     */
    private $items;
    
    
    /**
     * Languages constructor.
     *
     * @param Language ...$languages
     */
    private function __construct(Language ...$languages)
    {
        $this->items = $languages;
    }
    
    
    /**
     * @param Language ...$languages
     *
     * @return Languages
     */
    public static function create(Language ...$languages): Languages
    {
        return new self(...$languages);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator()
    {
        return new ArrayIterator($this->items());
    }
    
    
    /**
     * @inheritDoc
     */
    public function items(): array
    {
        return $this->items;
    }
}